/* Plugin Template generated by Pawn Studio */

new String:g_sql_loadplayer[]   = 
	"SELECT name, steamid, score, kills, deaths, shots, hits, time_played, headshots FROM players WHERE steamid = '%s'"

new String:g_sql_top[] = 
	"SELECT name, steamid, score, kills, deaths, shots, hits, time_played, headshots FROM players ORDER BY score DESC LIMIT %i OFFSET %i";

new String:g_sql_rank[] = 
	"SELECT DISTINCT score FROM players WHERE score >= %i ORDER BY score ASC;";

//new String:g_sql_rank_kills[] = 
	//"SELECT DISTINCT score FROM players WHERE kills >= %i ORDER BY kills ASC;";
	
public Native_Stats_GetPlayerSession(Handle:plugin, numParams)
{
	new client = GetNativeCell(1);
	new StatsCallback:callback = GetNativeCell(2);
	new any:data = GetNativeCell(3);
	new stats[MAX_STATS];
	
	stats[STAT_KILLS]       = g_session_kills[client];
	stats[STAT_DEATHS]      = g_session_deaths[client];
	stats[STAT_HITS]        = g_session_hits[client];
	stats[STAT_SHOTS]       = g_session_shots[client];
	stats[STAT_SCORE]       = g_session_score[client];
	stats[STAT_HEADSHOTS]   = g_session_headshots[client];
	stats[STAT_TIME_PLAYED] = GetTime() - g_time_joined[client];
	
	CallStatsCallback(g_name[client], g_steamid[client], stats, callback, data, 0);
}

public Native_Stats_GetPlayersByRank(Handle:plugin, numParams)
{
	new rank = GetNativeCell(1);
	new count = GetNativeCell(2);
	new StatsCallback:callback = GetNativeCell(3);
	new any:data = GetNativeCell(4);
	
	new Handle:pack = CreateDataPack();
	
	WritePackCell(pack, _:callback);
	WritePackCell(pack, data);
	
	new String:query[192];
	
	Format(query, sizeof(query), g_sql_top, count, rank - 1);
	SQL_TQuery(stats_db, SQL_TopCallback, query, pack);
}

public SQL_TopCallback(Handle:owner, Handle:hndl, const String:error[], any:data)
{
	new Handle:pack = data;
	ResetPack(pack);
	new StatsCallback:callback = StatsCallback:ReadPackCell(pack);
	new any:args = ReadPackCell(pack);
	CloseHandle(pack);
	
	decl String:name[MAX_NAME_LENGTH];
	decl String:steamid[MAX_STEAMID_LENGTH];
	
	new stats[MAX_STATS];
	new index = 0;
	
	if(SQL_HasResultSet(hndl))
	{
		while(SQL_FetchRow(hndl))
		{
			index++;
			SQL_FetchString(hndl, 0, name, sizeof(name));
			SQL_FetchString(hndl, 1, steamid, sizeof(steamid));
			stats[STAT_SCORE]       = SQL_FetchInt(hndl, 2);
			stats[STAT_KILLS]       = SQL_FetchInt(hndl, 3);
			stats[STAT_DEATHS]      = SQL_FetchInt(hndl, 4);
			stats[STAT_SHOTS]       = SQL_FetchInt(hndl, 5);
			stats[STAT_HITS]        = SQL_FetchInt(hndl, 6);
			stats[STAT_TIME_PLAYED] = SQL_FetchInt(hndl, 7);
			stats[STAT_HEADSHOTS]   = SQL_FetchInt(hndl, 8);
			
			CallStatsCallback(name, steamid, stats, callback, args, index);
		}
	}
	CallStatsCallback("", "", stats, callback, args, 0);
}

public Native_Stats_GetPlayerById(Handle:plugin, numParams)
{
	new client = GetNativeCell(1);
	new StatsCallback:callback = GetNativeCell(2);
	new any:data = GetNativeCell(3);
	new stats[MAX_STATS];
	
	stats[STAT_KILLS]       = g_kills[client];
	stats[STAT_DEATHS]      = g_deaths[client];
	stats[STAT_HITS]        = g_hits[client];
	stats[STAT_SHOTS]       = g_shots[client];
	stats[STAT_SCORE]       = g_score[client];
	stats[STAT_TIME_PLAYED] = g_time_played[client] + 
							  (GetTime() - 
							   g_time_joined[client]);
	stats[STAT_HEADSHOTS]   = g_headshots[client];

	CallStatsCallback(g_name[client], g_steamid[client], stats, callback, data, 0);
}

public Native_Stats_GetPlayerBySteamId(Handle:plugin, numParams)
{
	decl String:steamid[MAX_STEAMID_LENGTH];
	GetNativeString(1, steamid, sizeof(steamid));
	new StatsCallback:callback = GetNativeCell(2);
	new any:data = GetNativeCell(3);
	
	GetPlayerBySteamId(steamid, callback, data);
}

public SQL_LoadPlayerCallback(Handle:owner, Handle:hndl, const String:error[], any:data)
{
	new Handle:pack = data;
	ResetPack(pack);
	new StatsCallback:callback = StatsCallback:ReadPackCell(pack);
	new any:args = ReadPackCell(pack);
	CloseHandle(pack);
	
	if(hndl == INVALID_HANDLE)
	{
		LogError("[SoD-Stats] SQL_LoadPlayerCallback failure: %s", error);
		return;
	}
	
	new stats[MAX_STATS];
	new String:name[MAX_NAME_LENGTH];
	new String:steamid[MAX_STEAMID_LENGTH];
	new callback_error = ERROR_PLAYER_NOT_FOUND;
	
	if(SQL_HasResultSet(hndl) && SQL_FetchRow(hndl))
	{
		SQL_FetchString(hndl, 0, name, sizeof(name));
		SQL_FetchString(hndl, 1, steamid, sizeof(steamid));
		stats[STAT_SCORE]       = SQL_FetchInt(hndl, 2);
		stats[STAT_KILLS]       = SQL_FetchInt(hndl, 3);
		stats[STAT_DEATHS]      = SQL_FetchInt(hndl, 4);
		stats[STAT_SHOTS]       = SQL_FetchInt(hndl, 5);
		stats[STAT_HITS]        = SQL_FetchInt(hndl, 6);
		stats[STAT_TIME_PLAYED] = SQL_FetchInt(hndl, 7);
		stats[STAT_HEADSHOTS]   = SQL_FetchInt(hndl, 8);
		callback_error = 0;
	}
	
	CallStatsCallback(name, steamid, stats, callback, args, callback_error);
}

public Native_Stats_GetPlayerRank(Handle:plugin, numParams)
{
	new client = GetNativeCell(1);
	new StatsCallback:callback = GetNativeCell(2);
	new any:data = GetNativeCell(3);
	
	new Handle:pack = CreateDataPack();
	
	WritePackCell(pack, _:callback);
	WritePackCell(pack, data);
	
	new String:query[192];
	
	Format(query, sizeof(query), g_sql_rank, g_score[client]);
	SQL_TQuery(stats_db, SQL_RankCallback, query, pack);
}

public SQL_RankCallback(Handle:owner, Handle:hndl, const String:error[], any:data)
{
	new Handle:pack = data;
	ResetPack(pack);
	new StatsCallback:callback = StatsCallback:ReadPackCell(pack);
	new any:args = ReadPackCell(pack);
	CloseHandle(pack);
	
	if(hndl == INVALID_HANDLE)
	{
		LogError("[SoD-Stats] SQL_LoadPlayerCallback failure: %s", error);
		CallRankCallback(0, 0, callback, args, ERROR_PLAYER_NOT_FOUND);
		return;
	}
	
	new rank = SQL_GetRowCount(hndl);
	new current_score = 0;
	new next_score = 0;
	
	if(SQL_HasResultSet(hndl) && SQL_FetchRow(hndl))
	{
		current_score = SQL_FetchInt(hndl, 0);
		if(SQL_FetchRow(hndl))
		{
			next_score = SQL_FetchInt(hndl, 0);
			CallRankCallback(rank, next_score - current_score, callback, args, 0);
			return;
		}
	}
	
	CallRankCallback(rank, 0, callback, args, 0);
}

public Native_Stats_GetPlayerCount(Handle:plugin, numParams)
{
	return g_player_count;
}

public Native_Stats_Reset(Handle:plugin, numParams)
{
	ResetStats();
}

ResetStats()
{
	if(stats_db == INVALID_HANDLE)
	{
		LogError("[SoD-Stats] Error: Invalid database handle");
		return;
	}
	
	SQL_LockDatabase(stats_db);
	
	SQL_FastQuery(stats_db, g_sql_droptable_players);
	switch(g_dbtype)
	{
		case DBTYPE_MYSQL: 
			SQL_FastQuery(stats_db, g_mysql_createtable_players);
		case DBTYPE_SQLITE: 
			SQL_FastQuery(stats_db, g_sqlite_createtable_players);
	}
	
	g_player_count = 0;
	
	SQL_UnlockDatabase(stats_db);
	
	new max_clients = MAXPLAYERS+1;
	
	for(new i = 1; i < max_clients; i++)
	{
		if(g_initialized[i])
		{
			g_kills[i]       = 0;
			g_deaths[i]      = 0;
			g_shots[i]       = 0;
			g_hits[i]        = 0;
			g_score[i]       = 0;
			g_time_played[i] = 0;
			g_headshots[i]   = 0;
			
			g_session_score[i] = 0;
			g_session_kills[i] = 0;
			g_session_deaths[i] = 0;
			g_session_hits[i] = 0;
			g_session_shots[i] = 0;
			g_session_headshots[i] = 0;
			
			g_time_joined[i] = GetTime();
			
			CreatePlayer(i, g_steamid[i]);
		}
	}
}

CallStatsCallback(const String:name[], const String:steamid[], stats[], StatsCallback:callback, any:data, retval)
{
	Call_StartFunction(INVALID_HANDLE, callback);
	Call_PushString(name);
	Call_PushString(steamid);
	Call_PushArray(stats, MAX_STATS);
	Call_PushCell(data);
	Call_PushCell(retval);
	Call_Finish();
}

CallRankCallback(rank, delta, StatsCallback:callback, any:data, error)
{
	Call_StartFunction(INVALID_HANDLE, callback);
	Call_PushCell(rank);
	Call_PushCell(delta);
	Call_PushCell(data);
	Call_PushCell(error);
	Call_Finish();
}

GetPlayerBySteamId(const String:steamid[], StatsCallback:callback, any:data)
{
	new String:query[192];
	
	new Handle:pack = CreateDataPack();
	
	WritePackCell(pack, _:callback);
	WritePackCell(pack, data);
	
	Format(query, sizeof(query), g_sql_loadplayer, steamid);
	SQL_TQuery(stats_db, SQL_LoadPlayerCallback, query, pack);
}

public bool:AskPluginLoad(Handle:myself, bool:late, String:error[])
{
	CreateNative("Stats_GetPlayerCount",     Native_Stats_GetPlayerCount);
	CreateNative("Stats_GetPlayerSession",   Native_Stats_GetPlayerSession);
	CreateNative("Stats_GetPlayersByRank",   Native_Stats_GetPlayersByRank);
	CreateNative("Stats_GetPlayerById",      Native_Stats_GetPlayerById);
	CreateNative("Stats_GetPlayerBySteamId", Native_Stats_GetPlayerBySteamId);
	CreateNative("Stats_GetPlayerRank",      Native_Stats_GetPlayerRank);
	CreateNative("Stats_Reset",              Native_Stats_Reset);
	
	return true;
}
